﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                xmlns:tns="urn:Cymbeline.Diagnostics.PerfCounters"
                exclude-result-prefixes="msxsl">
    <xsl:output method="text" indent="no"/>

    <xsl:param name="TargetNamespace" />
    <xsl:param name="TargetClassName" select="'PerfCounters'" />
    <xsl:param name="AccessModifier" select="'public'" />

    <xsl:template match="tns:PerfCounters">
        <xsl:if test="$TargetNamespace=''">
            <xsl:message terminate="yes">
                The Parameter 'TargetNamespace' is undefined.
            </xsl:message>
        </xsl:if>
        <xsl:text>
// PLEASE NOTE
//   This code was auto-generated by a tool. Changes to this file will be lost upon
//   recompilation.

using System;
using System.Diagnostics;

namespace </xsl:text><xsl:value-of select="$TargetNamespace"/><xsl:text>
{
    </xsl:text><xsl:value-of select="$AccessModifier"/><xsl:text> sealed partial class </xsl:text><xsl:value-of select="$TargetClassName"/><xsl:text>
    {
        // Static classes for Performance Counter Categories.
</xsl:text>
        <xsl:apply-templates mode="Category" />
        <xsl:text><![CDATA[

        ]]></xsl:text><xsl:value-of select="$AccessModifier"/><xsl:text> static void Setup()
        {
            Console.WriteLine("Creating performance counters.");
</xsl:text>
        <xsl:for-each select="tns:Category">
            <xsl:text>
            Setup</xsl:text><xsl:value-of select="@Symbol"/><xsl:text>Category();
</xsl:text>
        </xsl:for-each>
        <xsl:text>
            Console.WriteLine("Finished creating performance counters.");
        }

        </xsl:text><xsl:value-of select="$AccessModifier"/><xsl:text> static void Remove()
        {
            Console.WriteLine("Removing performance counters.");
</xsl:text>
        <xsl:for-each select="tns:Category">
            <xsl:text>
            RemoveCategoryIfExists("</xsl:text><xsl:value-of select="@Name"/><xsl:text>");
</xsl:text>
        </xsl:for-each>
        <xsl:text>
            Console.WriteLine("Removing removing performance counters.");
        }

        private static void RemoveCategoryIfExists(string categoryName)
        {
            if (!PerformanceCounterCategory.Exists(categoryName))
            {
                Console.WriteLine("The performance counter category '{0}' does not exist.", categoryName);

                return;
            }

            Console.WriteLine("Removing performance counter category '{0}'.", categoryName);

            PerformanceCounterCategory.Delete(categoryName);
        }

        // Helper methods for managing perf counters per category.
</xsl:text>
        <xsl:apply-templates mode="ManageCategory" />
        <xsl:text>
    }
}
</xsl:text>
    </xsl:template>

    <xsl:template match="tns:Category" mode="Category">
        <xsl:text><![CDATA[
        ]]></xsl:text><xsl:value-of select="$AccessModifier"/><xsl:text> static class </xsl:text><xsl:value-of select="@Symbol"/><xsl:text>
        {
</xsl:text><xsl:apply-templates mode="Counter" /><xsl:text>

            private static bool _initialized = false;

            private static void MakeSureCountersAreInitialized()
            {
                if (_initialized)
                {
                    return;
                }

                _initialized = true;

                const string CategoryName = "</xsl:text><xsl:value-of select="@Name" /><xsl:text>";
</xsl:text><xsl:apply-templates mode="InitCounter" /><xsl:text>
            }
        }
</xsl:text>
    </xsl:template>

    <xsl:template match="tns:Category" mode="ManageCategory">
        <xsl:text>
        private static void Setup</xsl:text><xsl:value-of select="@Symbol"/>Category()<xsl:text>
        {
            const string CategoryName = "</xsl:text><xsl:value-of select="@Name" /><xsl:text>";
            RemoveCategoryIfExists(CategoryName);

            Console.WriteLine("Creating performance counters for category '" + CategoryName + "'.");

            // Create a collection of type CounterCreationDataCollection.
            CounterCreationDataCollection counters = new CounterCreationDataCollection();

</xsl:text>
        <xsl:apply-templates mode="CreateCounter" />
        <xsl:text>
            // Create the category and pass the collection to it.
            PerformanceCounterCategory.Create(CategoryName,
                "</xsl:text><xsl:value-of select="@Help" /><xsl:text>",
                PerformanceCounterCategoryType.SingleInstance, counters);
        }
</xsl:text>
    </xsl:template>

    <xsl:template match="tns:Counter" mode="Counter">
        <xsl:text>
            private static PerformanceCounter _</xsl:text><xsl:value-of select="@Symbol"/><xsl:text>;

            </xsl:text><xsl:value-of select="$AccessModifier"/><xsl:text> static PerformanceCounter </xsl:text><xsl:value-of select="@Symbol"/><xsl:text>
            {
                get
                {
                    MakeSureCountersAreInitialized();
                    return _</xsl:text><xsl:value-of select="@Symbol"/><xsl:text>;
                }
            }
</xsl:text>
    </xsl:template>

    <xsl:template match="tns:Counter[@Type='RawFraction']" mode="Counter">
        <xsl:text>
            private static PerformanceCounter _</xsl:text><xsl:value-of select="@Symbol"/><xsl:text>;

            </xsl:text><xsl:value-of select="$AccessModifier"/><xsl:text> static PerformanceCounter </xsl:text><xsl:value-of select="@Symbol"/><xsl:text>
            {
                get
                {
                    MakeSureCountersAreInitialized();
                    return _</xsl:text><xsl:value-of select="@Symbol"/><xsl:text>;
                }
            }

            private static PerformanceCounter _</xsl:text><xsl:value-of select="@Symbol"/><xsl:text>Base;

            </xsl:text><xsl:value-of select="$AccessModifier"/><xsl:text> static PerformanceCounter </xsl:text><xsl:value-of select="@Symbol"/><xsl:text>Base
            {
                get
                {
                    MakeSureCountersAreInitialized();
                    return _</xsl:text><xsl:value-of select="@Symbol"/><xsl:text>Base;
                }
            }
</xsl:text>
    </xsl:template>

    <xsl:template match="tns:Counter" mode="InitCounter">
        <xsl:text>
                _</xsl:text><xsl:value-of select="@Symbol"/><xsl:text> = new PerformanceCounter(
                    CategoryName,
                    "</xsl:text><xsl:value-of select="@Name"/><xsl:text>",
                    false);
</xsl:text>
    </xsl:template>

    <xsl:template match="tns:Counter[@Type='RawFraction']" mode="InitCounter">
        <xsl:text>
                _</xsl:text><xsl:value-of select="@Symbol"/><xsl:text> = new PerformanceCounter(
                    CategoryName,
                    "</xsl:text><xsl:value-of select="@Name"/><xsl:text>",
                    false);

                _</xsl:text><xsl:value-of select="@Symbol"/><xsl:text>Base = new PerformanceCounter(
                    CategoryName,
                    "</xsl:text><xsl:value-of select="@Name"/><xsl:text> Base",
                    false);
</xsl:text>
    </xsl:template>

    <xsl:template match="tns:Counter" mode="CreateCounter">
            <xsl:text>
            {
                CounterCreationData counter = new CounterCreationData();

                counter.CounterName = "</xsl:text><xsl:value-of select="@Name" /><xsl:text>";
                counter.CounterHelp = "</xsl:text><xsl:value-of select="@Help" /><xsl:text>";
                counter.CounterType = PerformanceCounterType.</xsl:text><xsl:value-of select="@Type" /><xsl:text>;

                counters.Add(counter);
            }
</xsl:text>
    </xsl:template>

    <xsl:template match="tns:Counter[@Type='RawFraction']" mode="CreateCounter">
            <xsl:text>
            {
                CounterCreationData counter = new CounterCreationData();

                counter.CounterName = "</xsl:text><xsl:value-of select="@Name" /><xsl:text>";
                counter.CounterHelp = "</xsl:text><xsl:value-of select="@Help" /><xsl:text>";
                counter.CounterType = PerformanceCounterType.</xsl:text><xsl:value-of select="@Type" /><xsl:text>;

                CounterCreationData counterBase = new CounterCreationData();

                counterBase.CounterName = "</xsl:text><xsl:value-of select="@Name" /><xsl:text> Base";
                counterBase.CounterHelp = "</xsl:text><xsl:value-of select="@Help" /><xsl:text>";
                counterBase.CounterType = PerformanceCounterType.RawBase;

                counters.AddRange(new CounterCreationData[]{counter, counterBase});
            }
</xsl:text>
    </xsl:template>
    <xsl:template match="tns:Counter[@Type='RawBase']" mode="CreateCounter" />

    <xsl:template match="text()" />
    <xsl:template match="text()" mode="Category" />
    <xsl:template match="text()" mode="ManageCategory" />
    <xsl:template match="text()" mode="Counter" />
    <xsl:template match="text()" mode="InitCounter" />
    <xsl:template match="text()" mode="CreateCounter" />
</xsl:stylesheet>
