﻿
// PLEASE NOTE
//   This code was auto-generated by a tool. Changes to this file will be lost upon
//   recompilation.

using System;
using System.Diagnostics;

namespace ch.cymbeline.Mail.Server.Diag
{
    public sealed partial class PerfCounters
    {
        // Static classes for Performance Counter Categories.

        public static class CymbeMail
        {

            private static PerformanceCounter _TotalConnections;

            public static PerformanceCounter TotalConnections
            {
                get
                {
                    MakeSureCountersAreInitialized();
                    return _TotalConnections;
                }
            }

            private static PerformanceCounter _TotalRefusedConnections;

            public static PerformanceCounter TotalRefusedConnections
            {
                get
                {
                    MakeSureCountersAreInitialized();
                    return _TotalRefusedConnections;
                }
            }

            private static PerformanceCounter _TotalErroneousConnections;

            public static PerformanceCounter TotalErroneousConnections
            {
                get
                {
                    MakeSureCountersAreInitialized();
                    return _TotalErroneousConnections;
                }
            }

            private static PerformanceCounter _ActiveConnections;

            public static PerformanceCounter ActiveConnections
            {
                get
                {
                    MakeSureCountersAreInitialized();
                    return _ActiveConnections;
                }
            }

            private static PerformanceCounter _AuthorizationRecords;

            public static PerformanceCounter AuthorizationRecords
            {
                get
                {
                    MakeSureCountersAreInitialized();
                    return _AuthorizationRecords;
                }
            }

            private static PerformanceCounter _ConnectionsPerSec;

            public static PerformanceCounter ConnectionsPerSec
            {
                get
                {
                    MakeSureCountersAreInitialized();
                    return _ConnectionsPerSec;
                }
            }

            private static PerformanceCounter _RefusedConnectionsPerSec;

            public static PerformanceCounter RefusedConnectionsPerSec
            {
                get
                {
                    MakeSureCountersAreInitialized();
                    return _RefusedConnectionsPerSec;
                }
            }


            private static bool _initialized = false;

            private static void MakeSureCountersAreInitialized()
            {
                if (_initialized)
                {
                    return;
                }

                _initialized = true;

                const string CategoryName = "CymbeMail";

                _TotalConnections = new PerformanceCounter(
                    CategoryName,
                    "# Total Connections",
                    false);

                _TotalRefusedConnections = new PerformanceCounter(
                    CategoryName,
                    "# Total Connections Refused",
                    false);

                _TotalErroneousConnections = new PerformanceCounter(
                    CategoryName,
                    "# Total Connections with Errors",
                    false);

                _ActiveConnections = new PerformanceCounter(
                    CategoryName,
                    "# Active Connections",
                    false);

                _AuthorizationRecords = new PerformanceCounter(
                    CategoryName,
                    "# Authorization Records",
                    false);

                _ConnectionsPerSec = new PerformanceCounter(
                    CategoryName,
                    "# Connections/sec",
                    false);

                _RefusedConnectionsPerSec = new PerformanceCounter(
                    CategoryName,
                    "# Refused Connections/sec",
                    false);

            }
        }


        public static void Setup()
        {
            Console.WriteLine("Creating performance counters.");

            SetupCymbeMailCategory();

            Console.WriteLine("Finished creating performance counters.");
        }

        public static void Remove()
        {
            Console.WriteLine("Removing performance counters.");

            RemoveCategoryIfExists("CymbeMail");

            Console.WriteLine("Removing removing performance counters.");
        }

        private static void RemoveCategoryIfExists(string categoryName)
        {
            if (!PerformanceCounterCategory.Exists(categoryName))
            {
                Console.WriteLine("The performance counter category '{0}' does not exist.", categoryName);

                return;
            }

            Console.WriteLine("Removing performance counter category '{0}'.", categoryName);

            PerformanceCounterCategory.Delete(categoryName);
        }

        // Helper methods for managing perf counters per category.

        private static void SetupCymbeMailCategory()
        {
            const string CategoryName = "CymbeMail";
            RemoveCategoryIfExists(CategoryName);

            Console.WriteLine("Creating performance counters for category '" + CategoryName + "'.");

            // Create a collection of type CounterCreationDataCollection.
            CounterCreationDataCollection counters = new CounterCreationDataCollection();


            {
                CounterCreationData counter = new CounterCreationData();

                counter.CounterName = "# Total Connections";
                counter.CounterHelp = "The total number of connections since the server was started.";
                counter.CounterType = PerformanceCounterType.NumberOfItems32;

                counters.Add(counter);
            }

            {
                CounterCreationData counter = new CounterCreationData();

                counter.CounterName = "# Total Connections Refused";
                counter.CounterHelp = "The total number of connections refused since the server was started.";
                counter.CounterType = PerformanceCounterType.NumberOfItems32;

                counters.Add(counter);
            }

            {
                CounterCreationData counter = new CounterCreationData();

                counter.CounterName = "# Total Connections with Errors";
                counter.CounterHelp = "The total number of connections which reported errors since the server was started.";
                counter.CounterType = PerformanceCounterType.NumberOfItems32;

                counters.Add(counter);
            }

            {
                CounterCreationData counter = new CounterCreationData();

                counter.CounterName = "# Active Connections";
                counter.CounterHelp = "The number of currently active connections.";
                counter.CounterType = PerformanceCounterType.NumberOfItems32;

                counters.Add(counter);
            }

            {
                CounterCreationData counter = new CounterCreationData();

                counter.CounterName = "# Authorization Records";
                counter.CounterHelp = "The number of authorization records currently kept in the server.";
                counter.CounterType = PerformanceCounterType.NumberOfItems32;

                counters.Add(counter);
            }

            {
                CounterCreationData counter = new CounterCreationData();

                counter.CounterName = "# Connections/sec";
                counter.CounterHelp = "The number of connections per second.";
                counter.CounterType = PerformanceCounterType.RateOfCountsPerSecond32;

                counters.Add(counter);
            }

            {
                CounterCreationData counter = new CounterCreationData();

                counter.CounterName = "# Refused Connections/sec";
                counter.CounterHelp = "The number of connections refused per second.";
                counter.CounterType = PerformanceCounterType.RateOfCountsPerSecond32;

                counters.Add(counter);
            }

            // Create the category and pass the collection to it.
            PerformanceCounterCategory.Create(CategoryName,
                "CymbeMail SMTP Server v0",
                PerformanceCounterCategoryType.SingleInstance, counters);
        }

    }
}
